/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.html5;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.remote.ExecuteMethod;

public class RemoteLocalStorage
implements LocalStorage {
    private final ExecuteMethod executeMethod;

    public RemoteLocalStorage(ExecuteMethod executeMethod) {
        this.executeMethod = executeMethod;
    }

    @Override
    public String getItem(String key) {
        ImmutableMap<String, String> args = ImmutableMap.of("key", key);
        return (String)this.executeMethod.execute("getLocalStorageItem", args);
    }

    @Override
    public Set<String> keySet() {
        Collection result = (Collection)this.executeMethod.execute("getLocalStorageKeys", null);
        return new HashSet<String>(result);
    }

    @Override
    public void setItem(String key, String value) {
        ImmutableMap<String, String> args = ImmutableMap.of("key", key, "value", value);
        this.executeMethod.execute("setLocalStorageItem", args);
    }

    @Override
    public String removeItem(String key) {
        String value = this.getItem(key);
        ImmutableMap<String, String> args = ImmutableMap.of("key", key);
        this.executeMethod.execute("removeLocalStorageItem", args);
        return value;
    }

    @Override
    public void clear() {
        this.executeMethod.execute("clearLocalStorage", null);
    }

    @Override
    public int size() {
        Object response = this.executeMethod.execute("getLocalStorageSize", null);
        return Integer.parseInt(response.toString());
    }
}

