/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium.node;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;

public class ChromeMutator
implements Function<Capabilities, Capabilities> {
    private static final String CONFIG_UUID_CAPABILITY = "server:CONFIG_UUID";
    private final Capabilities config;

    public ChromeMutator(Capabilities config) {
        this.config = "chrome".equals(config.getBrowserName()) ? config : null;
    }

    @Override
    public Capabilities apply(Capabilities capabilities) {
        if (this.config == null || !"chrome".equals(capabilities.getBrowserName())) {
            return capabilities;
        }
        if (!Objects.equals(this.config.getCapability(CONFIG_UUID_CAPABILITY), capabilities.getCapability(CONFIG_UUID_CAPABILITY))) {
            return capabilities;
        }
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.putAll(capabilities.asMap());
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (capabilities.getCapability("goog:chromeOptions") instanceof Map) {
            Map asMap = (Map)capabilities.getCapability("goog:chromeOptions");
            options.putAll(asMap);
        }
        if (options.get("binary") == null && this.config.getCapability("chrome_binary") != null) {
            options.put("binary", this.config.getCapability("chrome_binary"));
        }
        toReturn.put("goog:chromeOptions", options);
        return new ImmutableCapabilities(toReturn);
    }
}

