/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.corejs.javascript;

import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.IdFunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.IdScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

public abstract class ES6Iterator
extends IdScriptableObject {
    protected boolean exhausted = false;
    private static final int Id_next = 1;
    private static final int Id_iterator = 2;
    private static final int Id_toStringTag = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    public static final String NEXT_METHOD = "next";
    public static final String DONE_PROPERTY = "done";
    public static final String VALUE_PROPERTY = "value";

    static void init(ScriptableObject scope, boolean sealed, IdScriptableObject prototype, String tag) {
        if (scope != null) {
            prototype.setParentScope(scope);
            prototype.setPrototype(ES6Iterator.getObjectPrototype(scope));
        }
        prototype.activatePrototypeMap(3);
        if (sealed) {
            prototype.sealObject();
        }
        if (scope != null) {
            scope.associateValue(tag, prototype);
        }
    }

    ES6Iterator() {
    }

    ES6Iterator(Scriptable scope) {
        Scriptable top = ScriptableObject.getTopLevelScope(scope);
        this.setParentScope(top);
        IdScriptableObject prototype = (IdScriptableObject)ScriptableObject.getTopScopeValue(top, this.getTag());
        this.setPrototype(prototype);
    }

    @Override
    protected void initPrototypeId(int id) {
        switch (id) {
            case 1: {
                this.initPrototypeMethod(this.getTag(), id, NEXT_METHOD, 0);
                return;
            }
            case 2: {
                this.initPrototypeMethod(this.getTag(), id, "@@iterator", "[Symbol.iterator]", 0);
                return;
            }
            case 3: {
                this.initPrototypeValue(3, "@@toStringTag", this.getClassName(), 3);
                return;
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(this.getTag())) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        if (!(thisObj instanceof ES6Iterator)) {
            throw ES6Iterator.incompatibleCallError(f);
        }
        ES6Iterator iterator = (ES6Iterator)thisObj;
        switch (id) {
            case 1: {
                return iterator.next(cx, scope);
            }
            case 2: {
                return iterator;
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    @Override
    protected int findPrototypeId(String s) {
        if (s.charAt(0) == 'n') {
            return 1;
        }
        if ("@@iterator".equals(s)) {
            return 2;
        }
        if ("@@toStringTag".equals(s)) {
            return 3;
        }
        return 0;
    }

    protected abstract boolean isDone(Context var1, Scriptable var2);

    protected abstract Object nextValue(Context var1, Scriptable var2);

    protected Object next(Context cx, Scriptable scope) {
        boolean done;
        Object value = Undefined.instance;
        boolean bl = done = this.isDone(cx, scope) || this.exhausted;
        if (!done) {
            value = this.nextValue(cx, scope);
        } else {
            this.exhausted = true;
        }
        return this.makeIteratorResult(cx, scope, done, value);
    }

    protected abstract String getTag();

    private Scriptable makeIteratorResult(Context cx, Scriptable scope, boolean done, Object value) {
        Scriptable iteratorResult = cx.newObject(scope);
        ScriptableObject.putProperty(iteratorResult, VALUE_PROPERTY, value);
        ScriptableObject.putProperty(iteratorResult, DONE_PROPERTY, (Object)done);
        return iteratorResult;
    }
}

