/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.svg;

import com.gargoylesoftware.htmlunit.javascript.host.svg.MatrixTransformer;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;

public class AwtMatrixTransformer
implements MatrixTransformer {
    private static final AffineTransform FLIP_X_TRANSFORM = new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    private static final AffineTransform FLIP_Y_TRANSFORM = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);

    private static AffineTransform toAffineTransform(MatrixTransformer.SvgMatrix svgMatrix) {
        return new AffineTransform(svgMatrix.getScaleX(), svgMatrix.getShearY(), svgMatrix.getShearX(), svgMatrix.getScaleY(), svgMatrix.getTranslateX(), svgMatrix.getTranslateY());
    }

    private static MatrixTransformer.SvgMatrix toSvgMatrix(AffineTransform affineTransform) {
        return new MatrixTransformer.SvgMatrix(affineTransform.getShearX(), affineTransform.getShearY(), affineTransform.getScaleX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }

    @Override
    public MatrixTransformer.SvgMatrix flipX(MatrixTransformer.SvgMatrix svgMatrix) {
        AffineTransform tr = AwtMatrixTransformer.toAffineTransform(svgMatrix);
        tr.concatenate(FLIP_X_TRANSFORM);
        return AwtMatrixTransformer.toSvgMatrix(tr);
    }

    @Override
    public MatrixTransformer.SvgMatrix flipY(MatrixTransformer.SvgMatrix svgMatrix) {
        AffineTransform tr = AwtMatrixTransformer.toAffineTransform(svgMatrix);
        tr.concatenate(FLIP_Y_TRANSFORM);
        return AwtMatrixTransformer.toSvgMatrix(tr);
    }

    @Override
    public MatrixTransformer.SvgMatrix inverse(MatrixTransformer.SvgMatrix svgMatrix) {
        try {
            AffineTransform tr = AwtMatrixTransformer.toAffineTransform(svgMatrix);
            tr = tr.createInverse();
            return AwtMatrixTransformer.toSvgMatrix(tr);
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("Failed to execute 'inverse' on 'SVGMatrix': The matrix is not invertible.");
        }
    }

    @Override
    public MatrixTransformer.SvgMatrix multiply(MatrixTransformer.SvgMatrix factor1, MatrixTransformer.SvgMatrix factor2) {
        AffineTransform f1 = AwtMatrixTransformer.toAffineTransform(factor1);
        AffineTransform f2 = AwtMatrixTransformer.toAffineTransform(factor2);
        f1.concatenate(f2);
        return AwtMatrixTransformer.toSvgMatrix(f1);
    }

    @Override
    public MatrixTransformer.SvgMatrix rotate(MatrixTransformer.SvgMatrix svgMatrix, double angle) {
        AffineTransform tr = AwtMatrixTransformer.toAffineTransform(svgMatrix);
        tr.rotate(Math.toRadians(angle));
        return AwtMatrixTransformer.toSvgMatrix(tr);
    }

    @Override
    public MatrixTransformer.SvgMatrix rotateFromVector(MatrixTransformer.SvgMatrix svgMatrix, double x, double y) {
        AffineTransform tr = AwtMatrixTransformer.toAffineTransform(svgMatrix);
        tr.rotate(Math.atan2(y, x));
        return AwtMatrixTransformer.toSvgMatrix(tr);
    }

    @Override
    public MatrixTransformer.SvgMatrix scale(MatrixTransformer.SvgMatrix svgMatrix, double factor) {
        return this.scaleNonUniform(svgMatrix, factor, factor);
    }

    @Override
    public MatrixTransformer.SvgMatrix scaleNonUniform(MatrixTransformer.SvgMatrix svgMatrix, double factorX, double factorY) {
        AffineTransform tr = AwtMatrixTransformer.toAffineTransform(svgMatrix);
        tr.scale(factorX, factorY);
        return AwtMatrixTransformer.toSvgMatrix(tr);
    }

    @Override
    public MatrixTransformer.SvgMatrix skewX(MatrixTransformer.SvgMatrix svgMatrix, double angle) {
        AffineTransform tr = AwtMatrixTransformer.toAffineTransform(svgMatrix);
        tr.concatenate(AffineTransform.getShearInstance(Math.tan(Math.toRadians(angle)), 0.0));
        return AwtMatrixTransformer.toSvgMatrix(tr);
    }

    @Override
    public MatrixTransformer.SvgMatrix skewY(MatrixTransformer.SvgMatrix svgMatrix, double angle) {
        AffineTransform tr = AwtMatrixTransformer.toAffineTransform(svgMatrix);
        tr.concatenate(AffineTransform.getShearInstance(0.0, Math.tan(Math.toRadians(angle))));
        return AwtMatrixTransformer.toSvgMatrix(tr);
    }

    @Override
    public MatrixTransformer.SvgMatrix translate(MatrixTransformer.SvgMatrix svgMatrix, double x, double y) {
        AffineTransform tr = AwtMatrixTransformer.toAffineTransform(svgMatrix);
        tr.translate(x, y);
        return AwtMatrixTransformer.toSvgMatrix(tr);
    }
}

