/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.arrays;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class ArrayBuffer
extends SimpleScriptable {
    private byte[] bytes_;

    public ArrayBuffer() {
    }

    public ArrayBuffer(byte[] bytes) {
        this.bytes_ = bytes;
    }

    @JsxConstructor
    public void constructor(int length) {
        if (length < 0) {
            throw ScriptRuntime.rangeError("invalid array length '" + length + "'.");
        }
        this.bytes_ = new byte[length];
    }

    @JsxGetter
    public int getByteLength() {
        return this.bytes_.length;
    }

    @JsxFunction
    public ArrayBuffer slice(Object begin, Object end) {
        int beginInt;
        if (begin == Undefined.instance || begin instanceof Boolean) {
            throw Context.reportRuntimeError("Invalid type " + begin.getClass().getName());
        }
        double beginNumber = Context.toNumber(begin);
        if (Double.isNaN(beginNumber)) {
            beginInt = 0;
        } else if (Double.isInfinite(beginNumber)) {
            if (beginNumber > 0.0) {
                byte[] byteArray = new byte[]{};
                ArrayBuffer arrayBuffer = new ArrayBuffer(byteArray);
                return arrayBuffer;
            }
            beginInt = 0;
        } else {
            beginInt = (int)beginNumber;
            if ((double)beginInt != beginNumber) {
                throw Context.reportRuntimeError("Invalid type " + begin.getClass().getName());
            }
        }
        double endNumber = end == Undefined.instance ? (double)this.getByteLength() : Context.toNumber(end);
        if (Double.isNaN(endNumber) || Double.isInfinite(endNumber) || endNumber < (double)beginInt) {
            endNumber = beginInt;
        }
        byte[] byteArray = new byte[(int)endNumber - beginInt];
        System.arraycopy(this.bytes_, beginInt, byteArray, 0, byteArray.length);
        ArrayBuffer arrayBuffer = new ArrayBuffer(byteArray);
        return arrayBuffer;
    }

    byte getByte(int index) {
        return this.bytes_[index];
    }

    public void setBytes(int index, byte[] array) {
        int i = array.length - 1;
        if (index + i >= this.bytes_.length) {
            i = this.bytes_.length - index - 1;
        }
        while (i >= 0) {
            this.bytes_[index + i] = array[i];
            --i;
        }
    }

    public byte[] getBytes() {
        return this.bytes_;
    }
}

