/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.css.parser.CSSErrorHandler;
import com.gargoylesoftware.css.parser.CSSParseException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCssErrorHandler
implements CSSErrorHandler,
Serializable {
    private static final Log LOG = LogFactory.getLog(DefaultCssErrorHandler.class);

    @Override
    public void error(CSSParseException exception) {
        LOG.warn("CSS error: " + DefaultCssErrorHandler.buildMessage(exception));
    }

    @Override
    public void fatalError(CSSParseException exception) {
        LOG.warn("CSS fatal error: " + DefaultCssErrorHandler.buildMessage(exception));
    }

    @Override
    public void warning(CSSParseException exception) {
        LOG.warn("CSS warning: " + DefaultCssErrorHandler.buildMessage(exception));
    }

    private static String buildMessage(CSSParseException exception) {
        String uri = exception.getURI();
        int line = exception.getLineNumber();
        int col = exception.getColumnNumber();
        if (null == uri) {
            return "[" + line + ":" + col + "] " + exception.getMessage();
        }
        return "'" + uri + "' [" + line + ":" + col + "] " + exception.getMessage();
    }
}

